# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EarlyTerminationEvent']


class EarlyTerminationEvent(BaseDataClass):
    """
    A data to:  define the adjusted dates associated with an early termination provision.
    """
    adjustedExerciseDate: datetime.date = Field(..., description="The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.")
    """
    The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
    """
    adjustedEarlyTerminationDate: datetime.date = Field(..., description="The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.")
    """
    The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
    """
    adjustedCashSettlementValuationDate: datetime.date = Field(..., description="The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.")
    """
    The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.
    """
    adjustedCashSettlementPaymentDate: datetime.date = Field(..., description="The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business date convention.")
    """
    The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business date convention.
    """
    adjustedExerciseFeePaymentDate: Optional[datetime.date] = Field(None, description="The date on which the exercise fee amount is paid. This date should already be adjusted for any applicable business day convention.")
    """
    The date on which the exercise fee amount is paid. This date should already be adjusted for any applicable business day convention.
    """
    
    @rosetta_condition
    def condition_0_FpML_ird_39(self):
        """
        FpML validation rule ird-39 - AdjustedExerciseDate must be before or equal to adjustedEarlyTerminationDate.
        """
        item = self
        return all_elements(rosetta_resolve_attr(self, "adjustedExerciseDate"), "<=", rosetta_resolve_attr(self, "adjustedEarlyTerminationDate"))
    
    @rosetta_condition
    def condition_1_FpML_ird_40(self):
        """
        FpML validation rule ird-40 - AdjustedExerciseDate must be before or equal to adjustedCashSettlementValuationDate.
        """
        item = self
        return all_elements(rosetta_resolve_attr(self, "adjustedExerciseDate"), "<=", rosetta_resolve_attr(self, "adjustedCashSettlementValuationDate"))
    
    @rosetta_condition
    def condition_2_FpML_ird_41(self):
        """
        FpML validation rule ird-41 - AdjustedCashSettlementValuationDate must be before or equal to adjustedCashSettlementPaymentDate.
        """
        item = self
        return all_elements(rosetta_resolve_attr(self, "adjustedCashSettlementValuationDate"), "<=", rosetta_resolve_attr(self, "adjustedCashSettlementPaymentDate"))

import cdm 
