# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AveragingStrikeFeature']


class AveragingStrikeFeature(BaseDataClass):
    """
    Defines the terms required to calculate the average observations associated with an averaging strike.
    """
    averagingCalculation: cdm.product.template.AveragingCalculation.AveragingCalculation = Field(..., description="Defines parameters for use in cases when a valuation or other term is based on an average of market observations.")
    """
    Defines parameters for use in cases when a valuation or other term is based on an average of market observations.
    """
    observationTerms: cdm.product.common.schedule.ObservationTerms.ObservationTerms = Field(..., description="Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. ")
    """
    Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. 
    """

import cdm 
import cdm.product.template.AveragingCalculation
import cdm.product.common.schedule.ObservationTerms
