# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AssetPayout']

from cdm.product.common.settlement.PayoutBase import PayoutBase

class AssetPayout(PayoutBase):
    """
    Security finance payout specification in case the product payout involves some form of security collateral, as in a securities financing transaction. Plus additional description for ICMA.
    """
    assetLeg: List[cdm.product.template.AssetLeg.AssetLeg] = Field([], description="Defines each asset movement as a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.")
    """
    Defines each asset movement as a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.
    """
    @rosetta_condition
    def cardinality_assetLeg(self):
        return check_cardinality(self.assetLeg, 1, None)
    
    underlier: cdm.base.staticdata.asset.common.Asset.Asset = Field(..., description="Specifies the Purchased Asset, usually a Security.")
    """
    Specifies the Purchased Asset, usually a Security.
    """
    minimumFee: Optional[cdm.observable.asset.Money.Money] = Field(None, description="A contractual minimum amount which the borrower will pay, regardless of the duration of the loan. A mechanism for making sure that a trade generates enough income.")
    """
    A contractual minimum amount which the borrower will pay, regardless of the duration of the loan. A mechanism for making sure that a trade generates enough income.
    """
    dividendTerms: Optional[cdm.product.template.DividendTerms.DividendTerms] = Field(None, description="Specifies the terms under which dividends received by the borrower are passed through to the lender.")
    """
    Specifies the terms under which dividends received by the borrower are passed through to the lender.
    """
    tradeType: Optional[cdm.product.template.AssetPayoutTradeTypeEnum.AssetPayoutTradeTypeEnum] = Field(None, description="The trade type, eg repurchase transaction or buy/sell-back.")
    """
    The trade type, eg repurchase transaction or buy/sell-back.
    """
    
    @rosetta_condition
    def condition_0_Quantity(self):
        """
        When there is an OptionPayout the quantity can be expressed as part of the payoutQuantity, or as part of the underlier in the case of a Swaption.  For all other payouts that extend PayoutBase the payoutQuantity is a mandatory attribute.
        """
        item = self
        return rosetta_attr_exists(rosetta_resolve_attr(self, "priceQuantity"))
    
    @rosetta_condition
    def condition_1_UnderlierNotCash(self):
        """
        The purchased asset in an assetPayout should not be cash.
        """
        item = self
        return (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "Cash")))

import cdm 
import cdm.product.template.AssetLeg
import cdm.base.staticdata.asset.common.Asset
import cdm.observable.asset.Money
import cdm.product.template.DividendTerms
import cdm.product.template.AssetPayoutTradeTypeEnum
