# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.qualification.functions.Qualify_Commodity_Option import Qualify_Commodity_Option
from cdm.product.common.settlement.SettlementTypeEnum import SettlementTypeEnum
from cdm.product.template.EconomicTerms import EconomicTerms

__all__ = ['Qualify_Commodity_Option_Cash']


@replaceable
def Qualify_Commodity_Option_Cash(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as a Option that can be exercised into an Commodity.
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    is_product =  (all_elements(Qualify_Commodity_Option(rosetta_resolve_attr(self, "economicTerms")), "=", True) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "OptionPayout")), "settlementTerms"), "settlementType"), "=", rosetta_resolve_attr(SettlementTypeEnum, "CASH")))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
