# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.qualification.functions.SettlementPayoutOnlyExists import SettlementPayoutOnlyExists
from cdm.product.qualification.functions.UnderlierQualification import UnderlierQualification
from cdm.base.staticdata.asset.common.AssetClassEnum import AssetClassEnum
from cdm.product.template.EconomicTerms import EconomicTerms

__all__ = ['Qualify_AssetClass_ForeignExchange']


@replaceable
def Qualify_AssetClass_ForeignExchange(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as having the Asset Class classification Foreign Exchange
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return all_elements(Qualify_AssetClass_ForeignExchange(rosetta_resolve_deep_attr(self, "economicTerms")), "=", True)
    
    def _else_fn0():
        return False
    
    optionUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "OptionPayout")), "underlier")
    settlementUnderliers = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "SettlementPayout"), "underlier")
    is_product =  (((SettlementPayoutOnlyExists(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout")) and (all_elements(list(map(lambda item: rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(item, "Observable"), "Asset"), "Cash")), rosetta_resolve_attr(self, "settlementUnderliers"))), "=", True) or all_elements(list(map(lambda item: UnderlierQualification(item, [], rosetta_resolve_attr(AssetClassEnum, "FOREIGN_EXCHANGE")), rosetta_resolve_attr(self, "settlementUnderliers"))), "=", True))) or rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "PerformancePayout"), "underlier"), "Observable"), "Index"), "ForeignExchangeRateIndex"))) or (rosetta_attr_exists(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout")), "OptionPayout")) and (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "Observable"), "Asset"), "Cash")) or if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "Product")), _then_fn0, _else_fn0))))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
