# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralAgreementFloatingRate']

from cdm.product.asset.FloatingRateBase import FloatingRateBase

class CollateralAgreementFloatingRate(FloatingRateBase):
    """
    Represents the parameters needed to calculate the floating rate paid on collateral holdings.
    """
    negativeInterest: bool = Field(..., description="Specifies how negative rates should be applied. If rates go negative, should the payment be reversed (true) or zeroed out (false)?")
    """
    Specifies how negative rates should be applied.  If rates go negative, should the payment be reversed (true) or zeroed out (false)?
    """
    compressibleSpread: bool = Field(..., description="Specifies how spreads should be applied in a low/negative rate environment. If true, spread is applied only if rate is positive.")
    """
    Specifies how spreads should be applied in a low/negative rate environment.  If true, spread is applied only if rate is positive.
    """

import cdm 
