# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['FloatingRateIndexMap']


class FloatingRateIndexMap(BaseDataClass):
    """
    A map for a single FRO to or from an equivalent or similar FRO in a different contractual definitions version.
    """
    index: List[cdm.base.staticdata.asset.rates.FloatingRateIndexEnum.FloatingRateIndexEnum] = Field([], description=" The FRO name that is being mapped to/from.")
    """
     The FRO name that is being mapped to/from.
    """
    contractualDefinitionIdentifier: Optional[cdm.observable.asset.fro.ContractualDefinitionIdentifier.ContractualDefinitionIdentifier] = Field(None, description="Contractual Definition to which the map applies. Includes Document Type and Document Version")
    """
    Contractual Definition to which the map applies. Includes Document Type and Document Version
    """
    identifier: Optional[cdm.base.staticdata.identifier.Identifier.Identifier] = Field(None, description="Corresponds to the unique identifier of the Contractual Definition to which the map applies")
    """
    Corresponds to the unique identifier of the Contractual Definition to which the map applies
    """
    
    @rosetta_condition
    def condition_0_Choice(self):
        """
        Choice between document uuid or document type and version
        """
        item = self
        return rosetta_check_one_of(self, 'identifier', 'contractualDefinitionIdentifier', necessity=False)

import cdm 
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum
import cdm.observable.asset.fro.ContractualDefinitionIdentifier
import cdm.base.staticdata.identifier.Identifier
