# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['StandardizedScheduleProductClassEnum']

class StandardizedScheduleProductClassEnum(Enum):
    BASIS_SWAP = "BasisSwap"
    CONTRACT_FOR_DIFFERENCE = "ContractForDifference"
    CORRELATION_SWAP = "CorrelationSwap"
    CREDIT_NTH_TO_DEFAULT = "CreditNthToDefault"
    CREDIT_TOTAL_RETURN_SWAP_ON_A_BOND = "CreditTotalReturnSwapOnABond"
    CROSS_CURRENCY_SWAP = "CrossCurrencySwap"
    DELIVERABLE_FORWARD = "DeliverableForward"
    DELIVERABLE_OPTION = "DeliverableOption"
    DELIVERABLE_OPTION_F = "DeliverableOptionF"
    DELIVERABLE_SWAP = "DeliverableSwap"
    DIVIDEND_SWAP = "DividendSwap"
    FIXED_FLOAT_SWAP = "FixedFloatSwap"
    FORWARD = "Forward"
    FORWARD_RATE_AGREEMENT = "ForwardRateAgreement"
    IR_EXOTIC_SWAP_WITH_AN_EXOTIC_COUPON_AGAINST_A_FLOATING_LEG = "IRExoticSwapWithAnExoticCouponAgainstAFloatingLeg"
    INDEX_CDS = "IndexCDS"
    INDEX_TRANCHE = "IndexTranche"
    NON_DELIVERABLE_CROSS_CURRENCY_SWAP = "NonDeliverableCrossCurrencySwap"
    NON_DELIVERABLE_FORWARD = "NonDeliverableForward"
    NON_DELIVERABLE_OPTION = "NonDeliverableOption"
    OPTION = "Option"
    SINGLE_NAME_CREDIT_DEFAULT_SWAP = "SingleNameCreditDefaultSwap"
    SWAP = "Swap"
    SWAP_WITH_CALLABLE_BERMUDAN_RIGHT_TO_ENTER_EXIT_SWAPS = "SwapWithCallableBermudanRightToEnterExitSwaps"
    SWAPS_AND_PORTFOLIO_SWAPS = "SwapsAndPortfolioSwaps"
    SWAPTION = "Swaption"
    SWAPTION_STRADDLE = "SwaptionStraddle"
    VARIANCE_SWAP = "VarianceSwap"
    VOLATILITY_SWAP = "VolatilitySwap"
