# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Representations']


class Representations(BaseDataClass):
    nonReliance: bool = Field(..., description="If true, then non reliance is applicable.")
    """
    If true, then non reliance is applicable.
    """
    agreementsRegardingHedging: bool = Field(..., description="If true, then agreements regarding hedging are applicable.")
    """
    If true, then agreements regarding hedging are applicable.
    """
    indexDisclaimer: Optional[bool] = Field(None, description="If present and true, then index disclaimer is applicable.")
    """
    If present and true, then index disclaimer is applicable.
    """
    additionalAcknowledgements: Optional[bool] = Field(None, description="If true, then additional acknowledgements are applicable.")
    """
    If true, then additional acknowledgements are applicable.
    """
    additionalBespokeTerms: List[cdm.legaldocumentation.transaction.Clause.Clause] = Field([], description="")

import cdm 
import cdm.legaldocumentation.transaction.Clause
