# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SpecifiedEntity']


class SpecifiedEntity(BaseDataClass):
    """
    The party specific election of Specified Entities for the Event of Default or Termination Event specified.
    """
    party: cdm.base.staticdata.party.Party.Party = Field(..., description="The elective party.")
    """
    The elective party.
    """
    specifiedEntityTerms: cdm.legaldocumentation.common.SpecifiedEntityTermsEnum.SpecifiedEntityTermsEnum = Field(..., description="The specified entity terms for the Event of Default or Termination Event specified.")
    """
    The specified entity terms for the Event of Default or Termination Event specified.
    """
    specifiedEntity: List[cdm.base.staticdata.party.LegalEntity.LegalEntity] = Field([], description="The specified entities for the Event of Default or Termination Event specified.")
    """
    The specified entities for the Event of Default or Termination Event specified.
    """
    materialSubsidiaryTerms: Optional[str] = Field(None, description="The meaning of Material Subsidiary for the Event of Default or Termination Event specified.")
    """
    The meaning of Material Subsidiary for the Event of Default or Termination Event specified.
    """
    otherSpecifiedEntityTerms: Optional[str] = Field(None, description="The non standard terms for the Event of Default or Termination Event specified.")
    """
    The non standard terms for the Event of Default or Termination Event specified.
    """
    
    @rosetta_condition
    def condition_0_SpecifiedEntity(self):
        """
        A validation rule to ensure that a SpecifiedEntity is specified when required.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "specifiedEntity"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "specifiedEntityTerms"), "=", rosetta_resolve_attr(SpecifiedEntityTermsEnum, "NAMED_SPECIFIED_ENTITY")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_MaterialSubsidiary(self):
        """
        A validation rule to ensure that Material Subsidiary terms are specified when required.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "materialSubsidiaryTerms"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "specifiedEntityTerms"), "=", rosetta_resolve_attr(SpecifiedEntityTermsEnum, "MATERIAL_SUBSIDIARY")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_OtherSpecifiedEntity(self):
        """
        A validation rule to ensure that non standard Specified Entity terms are provided when required.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "otherSpecifiedEntityTerms"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "specifiedEntityTerms"), "=", rosetta_resolve_attr(SpecifiedEntityTermsEnum, "OTHER_SPECIFIED_ENTITY")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.Party
import cdm.legaldocumentation.common.SpecifiedEntityTermsEnum
import cdm.base.staticdata.party.LegalEntity
from cdm.legaldocumentation.common.SpecifiedEntityTermsEnum import SpecifiedEntityTermsEnum
