# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.math.functions.Max import Max
from cdm.legaldocumentation.csa.MarginApproachEnum import MarginApproachEnum
from cdm.observable.asset.Money import Money

__all__ = ['CreditSupportAmount']


@replaceable
def CreditSupportAmount(marginAmount: Money, threshold: Money, marginApproach: MarginApproachEnum, marginAmountIA: Money | None, baseCurrency: str) -> Money:
    """
    Calculates the Credit Support Amount.
    
    Parameters 
    ----------
    marginAmount : Money
    The Base Currency Equivalent of an amount equal to the sum of the initial margin amounts.
    
    threshold : Money
    With respect to a party, the Base Currency Equivalent of the amount specified for that party, if no amount is specified, zero.
    
    marginApproach : MarginApproachEnum
    Specifies the margin approach specific to Initial Margin agreements.
    
    marginAmountIA : Money
    The Base Currency Equivalent of an amount equal to the sum of the Independent Amounts.
    
    baseCurrency : string
    Base Currency means the currency specified as such in Paragraph 13.
    
    Returns
    -------
    result : Money
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_CurrencyMatches(self):
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "marginAmountIA"), "unit"), "currency"))
        
        def _else_fn0():
            return True
        
        return ((all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "marginAmount"), "unit"), "currency")) and all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "threshold"), "unit"), "currency"))) and if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "marginAmountIA")), _then_fn0, _else_fn0))
    
    @rosetta_local_condition(_pre_registry)
    def condition_1_MarginAmountIA(self):
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "marginAmountIA"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "marginAmountIA")))
        
        def _else_fn0():
            return if_cond_fn(all_elements(rosetta_resolve_attr(self, "marginApproach"), "=", rosetta_resolve_attr(MarginApproachEnum, "GREATER_OF")), _then_fn1, _else_fn1)
        
        return if_cond_fn((all_elements(rosetta_resolve_attr(self, "marginApproach"), "=", rosetta_resolve_attr(MarginApproachEnum, "DISTINCT")) or all_elements(rosetta_resolve_attr(self, "marginApproach"), "=", rosetta_resolve_attr(MarginApproachEnum, "ALLOCATED"))), _then_fn0, _else_fn0)
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    def _then_fn1():
        return Max(rosetta_resolve_attr(self, "creditSupportAmountCalc"), rosetta_resolve_attr(rosetta_resolve_attr(self, "marginAmountIA"), "value"))
    
    def _else_fn1():
        return True
    
    def _then_fn0():
        return rosetta_resolve_attr(self, "creditSupportAmountCalc")
    
    def _else_fn0():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "marginApproach"), "=", rosetta_resolve_attr(MarginApproachEnum, "GREATER_OF")), _then_fn1, _else_fn1)
    
    creditSupportAmountCalc = Max((rosetta_resolve_attr(rosetta_resolve_attr(self, "marginAmount"), "value") - rosetta_resolve_attr(rosetta_resolve_attr(self, "threshold"), "value")), 0.0)
    result = _get_rosetta_object('Money', 'value', if_cond_fn((all_elements(rosetta_resolve_attr(self, "marginApproach"), "=", rosetta_resolve_attr(MarginApproachEnum, "DISTINCT")) or all_elements(rosetta_resolve_attr(self, "marginApproach"), "=", rosetta_resolve_attr(MarginApproachEnum, "ALLOCATED"))), _then_fn0, _else_fn0))
    result = set_rosetta_attr(rosetta_resolve_attr(self, 'result'), 'unit->currency', rosetta_resolve_attr(self, "baseCurrency"))
    
    
    return result

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
