# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ValueCashEnum']

class ValueCashEnum(Enum):
    """
    Details of how cash collateral is valued when resolving disputes.
    """
    CASH_AMOUNT = "Cash - Amount Thereof"
    """
    Cash - Amount thereof.
    """
    CASH_PERCENTAGE = "Cash - Amount Thereof multiplied by Valuation Percentage"
    """
    Cash - amount thereof multiplied by Valuation Percentage.
    """
    CASH_PERCENTAGE_LESS_HAIRCUT = "Cash - Amount Thereof multiplied by (Valuation Percentage - FX Haircut)"
    """
    Cash - Amount Thereof multiplied by (Valuation Percentage - FX Haircut).
    """
    OTHER = "Other"
    """
    Exception value.
    """
