# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ValuationDateDayEnum']

class ValuationDateDayEnum(Enum):
    """
    Defines the conditions for the day for a Valuation Date.
    """
    CALENDAR_DAY = "CalendarDay"
    """
    The Date can be a given day on the regular calendar.
    """
    FRI = "FRI"
    """
    Friday
    """
    LOCAL_BUSINESS_DAY = "LocalBusinessDay"
    """
    The Date must be a day on which commercial banks are open for general business in the local market.
    """
    MON = "MON"
    """
    Monday
    """
    NEW_YORK_BANKING_DAY = "New York Banking Day"
    """
    The Date must be a New York Banking Day, that is a day, other than a Saturday or Sunday, on which banks are open for general commercial business in New York, USA.
    """
    SAT = "SAT"
    """
    Saturday
    """
    SUN = "SUN"
    """
    Sunday
    """
    THU = "THU"
    """
    Thursday
    """
    TUE = "TUE"
    """
    Tuesday
    """
    WED = "WED"
    """
    Wednesday
    """
