# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ValuationDateDateEnum']

class ValuationDateDateEnum(Enum):
    """
    Defines whether the date of a Valuation is defined by a certain day of the week or a particular date in the month.
    """
    AS_SELECTED = "As Selected"
    """
    As Selected.
    """
    CALENDAR_DAY = "CalendarDay"
    """
    A specific day of the calendar, defined.
    """
    EACH = "Each"
    """
    Specific Valuation date frequency.
    """
    FOURTHLAST = "4th Last"
    """
    Specific Valuation date frequency.
    """
    LAST = "Last"
    """
    Specific Valuation date frequency.
    """
    SECONDLAST = "2nd Last"
    """
    Specific Valuation date frequency.
    """
    THIRDLAST = "3rd Last"
    """
    Specific Valuation date frequency.
    """
