# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ThresholdRatedPartyEnum']

class ThresholdRatedPartyEnum(Enum):
    """
    The enumerated values applicable where a Rated Party is defined within the Threshold clause.
    """
    ALL_AFFILIATES = "All Affiliates to the Party"
    """
    All Affiliates to the Party.
    """
    CREDIT_SUPPORT_PROVIDER = "CreditSupportProvider"
    """
    Credit Support Provider.
    """
    NAMED_AFFILIATE = "NamedAffiliate"
    """
    A Named Affiliate of the Party.
    """
    NAMED_ENTITY = "NamedEntity"
    """
    A Named Entity.
    """
    PARTY = "Party"
    """
    Party.
    """
    PARTY_OR_CREDIT_SUPPORT_PROVIDER = "PartyOrCreditSupportProvider"
    """
    The Party or Credit Support Provider.
    """
