# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Substitution']


class Substitution(BaseDataClass):
    """
    A class to specify the conditions under which the Security Provider can substitute posted collateral. The details required for 'Legacy' agreements are substantially different to those required for newer agreements; where the agreement is a 1994 or 1995 CSA, or 1995 CSD, the legacyConsent attribute needs to be used which contains additional values beyond a simple true/false value.
    """
    needsConsent: bool = Field(..., description="The election as to whether the Pledgor/Obligor/Chargor must obtain the Secured Partys consent for any collateral substitution.")
    """
    The election as to whether the Pledgor/Obligor/Chargor must obtain the Secured Partys consent for any collateral substitution.
    """
    substitutionDateLanguage: Optional[str] = Field(None, description="Substitution Date has the meaning specified in Paragraph4(d)(ii), unless otherwise specified.")
    """
    Substitution Date has the meaning specified in Paragraph4(d)(ii), unless otherwise specified.
    """
    specificConsentLanguage: Optional[str] = Field(None, description="Specific consent language might be specified by the parties.")
    """
    Specific consent language might be specified by the parties.
    """
    legacyConsent: Optional[cdm.legaldocumentation.csa.LegacyConsentEnum.LegacyConsentEnum] = Field(None, description="The process for substituting/exchanging one form of collateral held by a party for a different form of collateral, used with legacy agreements.")
    """
    The process for substituting/exchanging one form of collateral held by a party for a different form of collateral, used with legacy agreements.
    """

import cdm 
import cdm.legaldocumentation.csa.LegacyConsentEnum
