# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['SimmExceptionApplicableEnum']

class SimmExceptionApplicableEnum(Enum):
    """
    Values to specify the SIMM normalized exception approaches.
    """
    FALL_BACK_TO_MANDATORY_METHOD = "FallBackToMandatoryMethod"
    """
    The ISDA Standard Initial Margin Model exception is applicable as a Fallback to Mandatory Method.
    """
    MANDATORY_METHOD = "MandatoryMethod"
    """
    The ISDA Standard Initial Margin Model exception is applicable as a Mandatory Method.
    """
    OTHER_METHOD = "OtherMethod"
    """
    An alternative approach is described in the document.
    """
