# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SecurityInterestForObligations']


class SecurityInterestForObligations(BaseDataClass):
    """
    Security Interest for Obligations clause applicable to 1994 NY CSA, 1995 English Law CSA, 1995 English Law Credit Support Deed, 2016 English Law VM CSA and 2016 New York Law VM CSA.
    """
    party: List[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field([], description="The elective party to which the Security Interest for Obligations is applicable.")
    """
    The elective party to which the Security Interest for Obligations is applicable.
    """
    @rosetta_condition
    def cardinality_party(self):
        return check_cardinality(self.party, 2, None)
    
    obligations: cdm.legaldocumentation.csa.SecurityInterestObligationsEnum.SecurityInterestObligationsEnum = Field(..., description="A description of any additional obligations secured by the credit support arrangements.")
    """
    A description of any additional obligations secured by the credit support arrangements.
    """
    obligee: cdm.legaldocumentation.csa.SecurityInterestObligeeEnum.SecurityInterestObligeeEnum = Field(..., description="The party to whom obligations under the Master Agreement are owed and secured by the credit support arrangements.")
    """
    The party to whom obligations under the Master Agreement are owed and secured by the credit support arrangements.
    """
    other: Optional[str] = Field(None, description="Exception value.")
    """
    Exception value.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.legaldocumentation.csa.SecurityInterestObligationsEnum
import cdm.legaldocumentation.csa.SecurityInterestObligeeEnum
