# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['SecuritiesCTSTimeEnum']

class SecuritiesCTSTimeEnum(Enum):
    """
    Details the day on which securities collateral is required to be transferred relative to the Notification Time.
    """
    FIRST_DAY = "First Local Business Day"
    """
    The securities collateral should be transferred on the first local business day.
    """
    NEXT = "Next"
    """
    The securities collateral should be transferred on the next day.
    """
    OTHER = "Other"
    """
    Exception value.
    """
    SAME = "Same"
    """
    The securities collateral should be transferred on the same day.
    """
    SECOND_DAY = "Second Local Business Day"
    """
    The securities collateral should be transferred on the second local business day.
    """
    THIRD_DAY = "Third Local Business Day"
    """
    The securities collateral should be transferred on the third local business day.
    """
