# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SecuredPartyRightsEvent']


class SecuredPartyRightsEvent(BaseDataClass):
    """
    A class to specify Secured Party Rights Event language.
    """
    securedPartyRightsEventElection: List[cdm.legaldocumentation.csa.SecuredPartyRightsEventElection.SecuredPartyRightsEventElection] = Field([], description="")
    earlyTerminationDateOptionalLanguage: bool = Field(..., description="A boolean attribute to specify whether Failure to Pay Early Termination language is included (True) or excluded (False) from the agreement.")
    """
    A boolean attribute to specify whether Failure to Pay Early Termination language is included (True) or excluded (False) from the agreement.
    """
    failureToPayEarlyTermination: Optional[bool] = Field(None, description="A boolean attribute to specify whether Failure to Pay Early Termination language in the agreement is deemed applicable or not.")
    """
    A boolean attribute to specify whether Failure to Pay Early Termination language in the agreement is deemed applicable or not.
    """
    
    @rosetta_condition
    def condition_0_FailureToPayLanguage(self):
        """
        A data rule to enforce that the applicability of Failure to Pay language is only applied when Early Termination language is included.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "failureToPayEarlyTermination")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "earlyTerminationDateOptionalLanguage"), "=", False), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.SecuredPartyRightsEventElection
