# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['RegimeTerms']


class RegimeTerms(BaseDataClass):
    """
    A class that is used by the ApplicableRegime and the AdditionalRegime classes to specify the regulatory regime terms.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The party for which the regime terms are being specified when acting as collateral taker.")
    """
    The party for which the regime terms are being specified when acting as collateral taker.
    """
    isApplicable: Optional[cdm.legaldocumentation.csa.ExceptionEnum.ExceptionEnum] = Field(None, description="The specification of whether the regime is elected as applicable to the party when acting as collateral taker.")
    """
    The specification of whether the regime is elected as applicable to the party when acting as collateral taker.
    """
    asSpecified: Optional[str] = Field(None, description="The bespoke party specific Regime term elections applicable when specified.")
    """
    The bespoke party specific Regime term elections applicable when specified.
    """
    simmException: Optional[cdm.legaldocumentation.csa.SimmException.SimmException] = Field(None, description="The election for SIMM exception to the regulatory regime clause.")
    """
    The election for SIMM exception to the regulatory regime clause.
    """
    retrospectiveEffect: Optional[cdm.legaldocumentation.csa.RetrospectiveEffect.RetrospectiveEffect] = Field(None, description="Specifies the retrospective effect exception to the regulatory regime clause of Initial Margin documents as either a normalized value specified as part of an enumeration or a customized value specified of type string.")
    """
    Specifies the retrospective effect exception to the regulatory regime clause of Initial Margin documents as either a normalized value specified as part of an enumeration or a customized value specified of type string.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.legaldocumentation.csa.ExceptionEnum
import cdm.legaldocumentation.csa.SimmException
import cdm.legaldocumentation.csa.RetrospectiveEffect
