# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ProcessAgent']


class ProcessAgent(BaseDataClass):
    """
    A class to specify the Process Agent that might be appointed by the parties as part of a Credit Support Annex/Deed or Collateral Transfer Agreement.
    """
    partyElection: List[cdm.legaldocumentation.csa.ProcessAgentElection.ProcessAgentElection] = Field([], description="The parties' Process Agent election.")
    """
    The parties' Process Agent election.
    """
    @rosetta_condition
    def cardinality_partyElection(self):
        return check_cardinality(self.partyElection, 2, None)
    

import cdm 
import cdm.legaldocumentation.csa.ProcessAgentElection
