# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['PledgeeRepresentativeRider']


class PledgeeRepresentativeRider(BaseDataClass):
    """
    The terms of the Rider for the ISDA Euroclear 2019 Collateral Transfer Agreement with respect to the use of a Pledgee Representative attached to this Agreement.
    """
    isApplicable: bool = Field(..., description="Identification of whether the representative CTA provisions are applicable (True) or not applicable (False).")
    """
    Identification of whether the representative CTA provisions are applicable (True) or not applicable (False).
    """
    party: Optional[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field(None, description="Identification of the represented party.")
    """
    Identification of the represented party.
    """
    representativeTerms: Optional[str] = Field(None, description="The specific representative terms applicable when specified.")
    """
    The specific representative terms applicable when specified.
    """
    representativeEvent: Optional[cdm.legaldocumentation.csa.ExceptionEnum.ExceptionEnum] = Field(None, description="The specification of whether the representative event terms are applicable.")
    """
    The specification of whether the representative event terms are applicable.
    """
    representativeEventTerms: Optional[str] = Field(None, description="The specific representative event terms applicable when specified.")
    """
    The specific representative event terms applicable when specified.
    """
    representativeEndDate: Optional[cdm.base.datetime.CustomisableOffset.CustomisableOffset] = Field(None, description="The definition of representative end date in relation to a representative event.")
    """
    The definition of representative end date in relation to a representative event.
    """
    
    @rosetta_condition
    def condition_0_RepresentativeParty(self):
        """
        A data rule to enforce that representative terms and a represented party are specified when representative provisions are applicable.
        """
        item = self
        def _then_fn0():
            return (((rosetta_attr_exists(rosetta_resolve_attr(self, "party")) and rosetta_attr_exists(rosetta_resolve_attr(self, "representativeTerms"))) and rosetta_attr_exists(rosetta_resolve_attr(self, "representativeEvent"))) and rosetta_attr_exists(rosetta_resolve_attr(self, "representativeEndDate")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_RepresentativeEventTerms(self):
        """
        A data rule to enforce that representative event terms are specified when applicable.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "representativeEventTerms"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "representativeEvent"), "=", rosetta_resolve_attr(ExceptionEnum, "OTHER")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.legaldocumentation.csa.ExceptionEnum
import cdm.base.datetime.CustomisableOffset
from cdm.legaldocumentation.csa.ExceptionEnum import ExceptionEnum
