# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['NotificationTime']


class NotificationTime(BaseDataClass):
    """
    A class to specify the time by which a demand for the Transfer of Eligible Credit Support (IM) or Posted Credit Support (IM) needs to be made in order for the transfer to take place in accordance with the Transfer Timing provisions.
    """
    partyElections: List[cdm.legaldocumentation.csa.NotificationTimeElection.NotificationTimeElection] = Field([], description="The parties' Notification Time election.")
    """
    The parties' Notification Time election.
    """
    @rosetta_condition
    def cardinality_partyElections(self):
        return check_cardinality(self.partyElections, 2, None)
    
    disputeNotificationReference: Optional[bool] = Field(None, description="The determination of whether reference is made to dispute resolution notification timing in the agreement.")
    """
    The determination of whether reference is made to dispute resolution notification timing in the agreement.
    """
    transferTimingProviso: Optional[bool] = Field(None, description="The determination of whether transfer timing language is applicable or not.")
    """
    The determination of whether transfer timing language is applicable or not.
    """

import cdm 
import cdm.legaldocumentation.csa.NotificationTimeElection
