# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['NotRatedByEnum']

class NotRatedByEnum(Enum):
    """
    The enumerated values applicable to define the what conditions apply to trigger a Not Rated condition.
    """
    ALL = "All"
    """
    No rating is available for the Party for any of the stated Rating Agencies.
    """
    ONE = "One"
    """
    No rating is available for the Party for any one of the stated Rating Agencies.
    """
    TWO = "Two"
    """
    No rating is available for the Party for any two of the stated Rating Agencies.
    """
