# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyValuationDate']


class LegacyValuationDate(BaseDataClass):
    """
    Details of the days on which calculations are to be made to determine the Delivery Amount and/or Return Amount. For example the language in the document may state 'Valuation Date means each day which is a Local Business Day', to capture this the values would be: Date: EACH, Day: LBD, Frequency: NULL. Alternatively the language may state: 'Valuation Date means the 1st Local Business Day of each week', this would be captured as: Date: 1st, Day: LBD, Frequency: WEEKLY.
    """
    date: Optional[cdm.legaldocumentation.csa.ValuationDateDateEnum.ValuationDateDateEnum] = Field(None, description="Defines whether a date is defined by a certain day of the week or a particular date in the month. If not specified here, then additional language must be used.")
    """
    Defines whether a date is defined by a certain day of the week or a particular date in the month. If not specified here, then additional language must be used.
    """
    day: Optional[cdm.legaldocumentation.csa.ValuationDateDayEnum.ValuationDateDayEnum] = Field(None, description="Specific day(s) or day of the week, if any, specified for Valuation Time.")
    """
    Specific day(s) or day of the week, if any, specified for Valuation Time.
    """
    calendarDay: Optional[Decimal] = Field(None, description="Defines the day of the calendar if this is specified for in the ValuationDateDateEnum.")
    """
    Defines the day of the calendar if this is specified for in the ValuationDateDateEnum.
    """
    frequency: Optional[cdm.legaldocumentation.csa.ValuationDateFrequencyEnum.ValuationDateFrequencyEnum] = Field(None, description="Defines the regularity of the date specified for the Valuation Date.")
    """
    Defines the regularity of the date specified for the Valuation Date.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_CalendarDay(self):
        """
        If a specific calendar day is specified, it must be defined.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "calendarDay"))
        
        def _else_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "calendarDay")))
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "date"), "=", rosetta_resolve_attr(ValuationDateDateEnum, "CALENDAR_DAY")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_AdditionalLanguage(self):
        """
        If no methodology is defined, additional language must be specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(((not rosetta_attr_exists(rosetta_resolve_attr(self, "date"))) or (not rosetta_attr_exists(rosetta_resolve_attr(self, "frequency")))), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.ValuationDateDateEnum
import cdm.legaldocumentation.csa.ValuationDateDayEnum
import cdm.legaldocumentation.csa.ValuationDateFrequencyEnum
from cdm.legaldocumentation.csa.ValuationDateDateEnum import ValuationDateDateEnum
