# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyValuationAgent']


class LegacyValuationAgent(BaseDataClass):
    """
    Details of the party calculating the value of collateral to be delivered or returned.
    """
    party: Optional[cdm.legaldocumentation.csa.ValuationAgentPartyEnum.ValuationAgentPartyEnum] = Field(None, description="The elective party.")
    """
    The elective party.
    """
    valuationAgent: Optional[cdm.legaldocumentation.csa.LegacyValuationAgentEnum.LegacyValuationAgentEnum] = Field(None, description="Specifies how the Valuation Agent is determined.")
    """
    Specifies how the Valuation Agent is determined.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_AdditionalLanguage(self):
        """
        If no party is defined, additional language must be used to specify the elective party.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(self, "party"))), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.ValuationAgentPartyEnum
import cdm.legaldocumentation.csa.LegacyValuationAgentEnum
