# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['LegacyVMCustodianEnum']

class LegacyVMCustodianEnum(Enum):
    """
    Details of how the Custodian is determined.
    """
    AS_ADVISED_1_TO_2 = "As advised by Party 1 to Party 2"
    """
    The Custodian as advised by Party 1 to Party 2.
    """
    AS_ADVISED_2_TO_1 = "As advised by Party 2 to Party 1"
    """
    The Custodian as advised by Party 2 to Party 1.
    """
    NAMED_ENTITY = "NamedEntity"
    """
    A named entity is specified as the Custodian.
    """
    NOT_APPLICABLE = "NotApplicable"
    """
    Not Applicable.
    """
    PARTY_1_TO_PARTY_2 = "Party 1 will notify Party 2"
    """
    Party 1 will notify Party 2 of the custodian.
    """
    PARTY_2_TO_PARTY_1 = "Party 2 will notify Party 1"
    """
    Party 2 will notify Party 1 of the custodian.
    """
