# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyTransferSettlementTiming']


class LegacyTransferSettlementTiming(BaseDataClass):
    """
    Specification of transfer / settlement timing for cash and securities collateral assuming that the notice is provided before the Notification Time (and with a 1LBD lag introduced if the notice is delivered after the Notification Time), and that securities allow for a further Local Business Day for transfer / settlement.
    """
    cashCollateralTransferSettlementTime: Optional[cdm.legaldocumentation.csa.CashCTSTimeEnum.CashCTSTimeEnum] = Field(None, description="Details the day on which collateral is required to be transferred relative to the Notification Time.")
    """
    Details the day on which collateral is required to be transferred relative to the Notification Time.
    """
    securititesCollateralTransferSettlementTime: Optional[cdm.legaldocumentation.csa.SecuritiesCTSTimeEnum.SecuritiesCTSTimeEnum] = Field(None, description="Details the day on which collateral is required to be transferred relative to the Notification Time.")
    """
    Details the day on which collateral is required to be transferred relative to the Notification Time.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_OtherValues(self):
        """
        Additional language is required when 'Other' values are used.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((all_elements(rosetta_resolve_attr(self, "cashCollateralTransferSettlementTime"), "=", rosetta_resolve_attr(CashCTSTimeEnum, "OTHER")) or all_elements(rosetta_resolve_attr(self, "securititesCollateralTransferSettlementTime"), "=", rosetta_resolve_attr(SecuritiesCTSTimeEnum, "OTHER"))), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.CashCTSTimeEnum
import cdm.legaldocumentation.csa.SecuritiesCTSTimeEnum
from cdm.legaldocumentation.csa.CashCTSTimeEnum import CashCTSTimeEnum
from cdm.legaldocumentation.csa.SecuritiesCTSTimeEnum import SecuritiesCTSTimeEnum
