# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyResolutionValue']


class LegacyResolutionValue(BaseDataClass):
    """
    Methodology for resolving disputes in respect of the determination of the value of collateral.
    """
    cash: Optional[cdm.legaldocumentation.csa.ValueCashEnum.ValueCashEnum] = Field(None, description="Details of how cash collateral is valued when resolving disputes.")
    """
    Details of how cash collateral is valued when resolving disputes.
    """
    securities: Optional[cdm.legaldocumentation.csa.ValueSecuritiesEnum.ValueSecuritiesEnum] = Field(None, description="Details of how securities collateral is valued when resolving disputes.")
    """
    Details of how securities collateral is valued when resolving disputes.
    """
    fallback: Optional[bool] = Field(None, description="A boolean flag to represent whether a fallback calculation method is applicable.")
    """
    A boolean flag to represent whether a fallback calculation method is applicable.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_OtherValues(self):
        """
        Additional language is required when 'Other' values are used.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((all_elements(rosetta_resolve_attr(self, "cash"), "=", rosetta_resolve_attr(ValueCashEnum, "OTHER")) or all_elements(rosetta_resolve_attr(self, "securities"), "=", rosetta_resolve_attr(ValueSecuritiesEnum, "OTHER"))), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.ValueCashEnum
import cdm.legaldocumentation.csa.ValueSecuritiesEnum
from cdm.legaldocumentation.csa.ValueCashEnum import ValueCashEnum
from cdm.legaldocumentation.csa.ValueSecuritiesEnum import ValueSecuritiesEnum
