# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyExposureScopeElection']


class LegacyExposureScopeElection(BaseDataClass):
    """
    Specification of amendments to the calculation of Exposure in terms of the Transactions and Products covered.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    excludedTransactions: bool = Field(..., description="A boolean flag to represent whether any transactions are excluded (ie True) or not (ie False).")
    """
    A boolean flag to represent whether any transactions are excluded (ie True) or not (ie False).
    """
    excludedProducts: List[cdm.legaldocumentation.csa.ExcludedProducts.ExcludedProducts] = Field([], description="Description of the relevant derivative transactions excluded from the calculation of exposure.")
    """
    Description of the relevant derivative transactions excluded from the calculation of exposure.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.legaldocumentation.csa.ExcludedProducts
