# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['HoldingAndUsingPostedCollateralElection']


class HoldingAndUsingPostedCollateralElection(BaseDataClass):
    """
    A class to specify the parties' elections related to the holding and using of posted collateral.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    eligibilityToHoldCollateral: cdm.legaldocumentation.csa.EligibilityToHoldCollateral.EligibilityToHoldCollateral = Field(..., description="The specification of the conditions under which a party and its custodian(s) are entitled to hold posted collateral.")
    """
    The specification of the conditions under which a party and its custodian(s) are entitled to hold posted collateral.
    """
    useOfPostedCollateral: bool = Field(..., description="Specifies whether the party to the agreement has the right to rehypothecate the collateral held (True).")
    """
    Specifies whether the party to the agreement has the right to rehypothecate the collateral held (True).
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.legaldocumentation.csa.EligibilityToHoldCollateral
