# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['GeneralSimmElections']


class GeneralSimmElections(BaseDataClass):
    """
    A class to specify the ISDA SIMM as the Method for all Covered Transactions with respect to all Regimes.
    """
    simmVersion: Optional[cdm.legaldocumentation.csa.SimmVersion.SimmVersion] = Field(None, description="The qualification of the ISDA SIMM version that is specified for all Covered Transactions.")
    """
    The qualification of the ISDA SIMM version that is specified for all Covered Transactions.
    """
    simmCalculationCurrency: cdm.legaldocumentation.csa.SimmCalculationCurrency.SimmCalculationCurrency = Field(..., description="The SIMM Calculation Currency, as specified for each of the parties to the CSA Initial Margin.")
    """
    The SIMM Calculation Currency, as specified for each of the parties to the CSA Initial Margin.
    """

import cdm 
import cdm.legaldocumentation.csa.SimmVersion
import cdm.legaldocumentation.csa.SimmCalculationCurrency
