# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['FinalReturns']


class FinalReturns(BaseDataClass):
    """
    A clause providing that final return collateral is to be provided without consideration of any Minimum Transfer Amount and collateral haircut.
    """
    applicable: Optional[bool] = Field(None, description="Defines if the clause is applicable to this agreement or any other exceptions.")
    """
    Defines if the clause is applicable to this agreement or any other exceptions.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_AdditionalLanguage(self):
        """
        The additional language should be qualified only if the clause is specified as applicable.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_resolve_attr(self, "applicable"), _then_fn0, _else_fn0)

import cdm 
