# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExcludedProducts']


class ExcludedProducts(BaseDataClass):
    """
    Description of the relevant derivative transactions excluded from the calculation of exposure.
    """
    product: List[cdm.legaldocumentation.csa.ExposureScopeProductEnum.ExposureScopeProductEnum] = Field([], description="Description of the relevant derivative transactions excluded from the calculation of exposure.")
    """
    Description of the relevant derivative transactions excluded from the calculation of exposure.
    """
    branch: List[cdm.base.datetime.BusinessCenterEnum.BusinessCenterEnum] = Field([], description="Description of the specific branch entered into by the relevant party.")
    """
    Description of the specific branch entered into by the relevant party.
    """
    excluded: bool = Field(..., description="A flag to indicate whether transactions entered into by a specific branch with respect to the relevant party are excluded; set to True if excluded, false if included.")
    """
    A flag to indicate whether transactions entered into by a specific branch with respect to the relevant party are excluded; set to True if excluded, false if included.
    """

import cdm 
import cdm.legaldocumentation.csa.ExposureScopeProductEnum
import cdm.base.datetime.BusinessCenterEnum
