# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ExceptionEnum']

class ExceptionEnum(Enum):
    """
    Values to specify the normalized exceptions applicable to an Initial Margin CSA.
    """
    APPLICABLE = "Applicable"
    """
    The election is applicable.
    """
    NOT_APPLICABLE = "NotApplicable"
    """
    The election is not applicable.
    """
    OTHER = "Other"
    """
    An alternative approach is described in the document as follows.
    """
