# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['DatedAsOfDate']


class DatedAsOfDate(BaseDataClass):
    """
    Defines the dates agreed by the parties as the date of the Credit Support Annex or Credit Support Deed.
    """
    csaDatedAsOfDate: Optional[datetime.date] = Field(None, description="The date agreed by the parties as the Dated as of Date for the Credit Support Annex.")
    """
    The date agreed by the parties as the Dated as of Date for the Credit Support Annex.
    """
    masterAgreementDatedAsOfDate: Optional[datetime.date] = Field(None, description="The date agreed by the parties as the Dated as of Date for the Master Agreement.")
    """
    The date agreed by the parties as the Dated as of Date for the Master Agreement.
    """
    csaMadeOn: Optional[datetime.date] = Field(None, description="The date agreed by the parties as the Made On date of the Credit Support Deed.")
    """
    The date agreed by the parties as the Made On date of the Credit Support Deed.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """

import cdm 
