# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CustodianElection']


class CustodianElection(BaseDataClass):
    """
    A class to specify the custodian and custody account details for each party to the agreement.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    custodian: Optional[cdm.base.staticdata.party.LegalEntity.LegalEntity] = Field(None, description="The custody agent. While CreateiQ only specifies the custodian's name, specifying the legal entity as part of the CDM is deemed more appropriate, while this will still provide the ability to accommodate situations where only the entity name is available, as the entityId attribute is optional as part of the LegalEntity class.")
    """
    The custody agent. While CreateiQ only specifies the custodian's name, specifying the legal entity as part of the CDM is deemed more appropriate, while this will still provide the ability to accommodate situations where only the entity name is available, as the entityId attribute is optional as part of the LegalEntity class.
    """
    segregatedCashAccount: Optional[cdm.base.staticdata.party.Account.Account] = Field(None, description="The identification of the segregated cash account for the purpose of holding cash collateral.")
    """
    The identification of the segregated cash account for the purpose of holding cash collateral.
    """
    segregatedSecurityAccount: Optional[cdm.base.staticdata.party.Account.Account] = Field(None, description="The identification of the segregated security account for the purpose of holding security collateral.")
    """
    The identification of the segregated security account for the purpose of holding security collateral.
    """
    legacyVMCustodian: Optional[cdm.legaldocumentation.csa.LegacyVMCustodianEnum.LegacyVMCustodianEnum] = Field(None, description="Details how the Custodian is determined.")
    """
    Details how the Custodian is determined.
    """
    legacyNamedEntity: Optional[cdm.base.staticdata.party.LegalEntity.LegalEntity] = Field(None, description="The identity of the relevant custodian where Named Entity is elected.")
    """
    The identity of the relevant custodian where Named Entity is elected.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_NamedEntity(self):
        """
        The entity should be named if this is specified in the determination.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "legacyNamedEntity"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "legacyVMCustodian"), "=", rosetta_resolve_attr(LegacyVMCustodianEnum, "NAMED_ENTITY")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_AdditionalLanguage(self):
        """
        If no Custodian determination methodology is defined, additional language must be specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(self, "legacyVMCustodian"))), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.base.staticdata.party.LegalEntity
import cdm.base.staticdata.party.Account
import cdm.legaldocumentation.csa.LegacyVMCustodianEnum
from cdm.legaldocumentation.csa.LegacyVMCustodianEnum import LegacyVMCustodianEnum
