# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CreditSupportDocumentElection']


class CreditSupportDocumentElection(BaseDataClass):
    """
    The party election of Credit Support Provider(s), if any.
    """
    party: cdm.base.staticdata.party.Party.Party = Field(..., description="The elective party.")
    """
    The elective party.
    """
    creditSupportDocumentTerms: cdm.legaldocumentation.common.CreditSupportDocumentTermsEnum.CreditSupportDocumentTermsEnum = Field(..., description="Specification of the Credit Support Document terms.")
    """
    Specification of the Credit Support Document terms.
    """
    creditSupportDocument: List[cdm.legaldocumentation.common.LegalAgreement.LegalAgreement] = Field([], description="The specified Credit Support Document(s), if any.")
    """
    The specified Credit Support Document(s), if any.
    """
    bespokeCreditSuppportDocument: Optional[str] = Field(None, description="Specification of a document when not captured under RelatedAgreement.")
    """
    Specification of a document when not captured under RelatedAgreement.
    """
    
    @rosetta_condition
    def condition_0_CreditSupportDocument(self):
        """
        A validation rule to ensure that a Credit Support Document is specified when required.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "creditSupportDocument"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "creditSupportDocumentTerms"), "=", rosetta_resolve_attr(CreditSupportDocumentTermsEnum, "SPECIFIED")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.Party
import cdm.legaldocumentation.common.CreditSupportDocumentTermsEnum
import cdm.legaldocumentation.common.LegalAgreement
from cdm.legaldocumentation.common.CreditSupportDocumentTermsEnum import CreditSupportDocumentTermsEnum
