# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['CreditSupportAmountEnum']

class CreditSupportAmountEnum(Enum):
    """
    Specifies whether the meaning of credit support amount follows the pre-print definition or deviates from the standard (either based on a rating or some other methodology).
    """
    IA_FLOOR_GIA = "Non-Standard - IA Floor (Less GiverIA)"
    IA_FLOOR_GIATIA = "Non-Standard - IA Floor (Less GiverIA and TakerIA)"
    NON_STANDARD_OTHER = "Non-Standard - Other"
    NON_STANDARD_RATINGS = "Non-Standard - Ratings"
    STANDARD = "Standard"
    """
    The standard definition of the credit support amount applies.
    """
