# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CreditSupportAmount']


class CreditSupportAmount(BaseDataClass):
    """
    The total amount one counterparty must deliver to the other at any time: the combination of the Exposure to that party and the net Independent Amounts it must post, minus any agreed Threshold.
    """
    creditSupportAmount: cdm.legaldocumentation.csa.CreditSupportAmountEnum.CreditSupportAmountEnum = Field(..., description="Specifies whether the meaning of credit support amount follows the pre-print definition or deviates from the standard (either based on a rating or some other methodology).")
    """
    Specifies whether the meaning of credit support amount follows the pre-print definition or deviates from the standard (either based on a rating or some other methodology).
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_AdditionalLanguage(self):
        """
        If a Non Standard Other definition is defined, additional language must be specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "creditSupportAmount"), "=", rosetta_resolve_attr(CreditSupportAmountEnum, "NON_STANDARD_OTHER")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.CreditSupportAmountEnum
from cdm.legaldocumentation.csa.CreditSupportAmountEnum import CreditSupportAmountEnum
