# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ControlAgreementElections']


class ControlAgreementElections(BaseDataClass):
    """
    A class to specify the Control Agreement election sby each party to the agreement.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    controlAgreementAsCsd: bool = Field(..., description="The identification of whether the Control Agreement is a Credit Support Document with respect to each party.")
    """
    The identification of whether the Control Agreement is a Credit Support Document with respect to each party.
    """
    consistencyWithControlAgreement: Optional[bool] = Field(None, description="Unless specified as inapplicable in the event of any inconsistency between this Deed and the Control Agreement, this Deed will prevail over the Control Agreement.")
    """
    Unless specified as inapplicable in the event of any inconsistency between this Deed and the Control Agreement, this Deed will prevail over the Control Agreement.
    """
    relationshipWithControlAgreement: Optional[bool] = Field(None, description="Unless specified as inapplicable the parties recognise that the Control Agreement is a means by which the parties can perform their obligations.")
    """
    Unless specified as inapplicable the parties recognise that the Control Agreement is a means by which the parties can perform their obligations.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
