# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CalculationAndTiming']


class CalculationAndTiming(BaseDataClass):
    """
    A class to specify the Calculation, Valuation and Timing terms specific to the agreement.
    """
    calculationAgentTerms: Optional[cdm.legaldocumentation.csa.CalculationAgentTerms.CalculationAgentTerms] = Field(None, description="The calculation agent terms applicable to the agreement.")
    """
    The calculation agent terms applicable to the agreement.
    """
    bespokeCalculationDate: Optional[cdm.legaldocumentation.csa.BespokeCalculationDate.BespokeCalculationDate] = Field(None, description="The specification of bespoke Calculation Date terms for the purposes of Initial or Variation Margin by the parties to the agreement.")
    """
    The specification of bespoke Calculation Date terms for the purposes of Initial or Variation Margin by the parties to the agreement.
    """
    bespokeCalculationTime: Optional[cdm.legaldocumentation.csa.BespokeCalculationTime.BespokeCalculationTime] = Field(None, description="Bespoke terms to describe the time as of which such party (or the Calculation Agent (IM) (if applicale)) computes its end of day valuations of derivatives transactions.")
    """
    Bespoke terms to describe the time as of which such party (or the Calculation Agent (IM) (if applicale)) computes its end of day valuations of derivatives transactions.
    """
    calculationDateLocation: Optional[cdm.legaldocumentation.csa.CalculationDateLocation.CalculationDateLocation] = Field(None, description="The specified location where the credit exposure will be calculated by the respective parties.")
    """
    The specified location where the credit exposure will be calculated by the respective parties.
    """
    notificationTime: cdm.legaldocumentation.csa.NotificationTime.NotificationTime = Field(..., description="The time by which a demand for the Transfer of Eligible Credit Support (IM) or Posted Credit Support (IM) needs to be made in order for the transfer to take place in accordance with the Transfer Timing provisions.")
    """
    The time by which a demand for the Transfer of Eligible Credit Support (IM) or Posted Credit Support (IM) needs to be made in order for the transfer to take place in accordance with the Transfer Timing provisions.
    """
    collateralValuationAgent: Optional[cdm.legaldocumentation.csa.CollateralValuationAgent.CollateralValuationAgent] = Field(None, description="The bespoke Collateral Valuation Agent terms applicable to the agreement.")
    """
    The bespoke Collateral Valuation Agent terms applicable to the agreement.
    """
    cashSettlementDay: Optional[str] = Field(None, description="")
    securitiesSettlementDay: Optional[str] = Field(None, description="")
    legacyValuationDate: Optional[cdm.legaldocumentation.csa.LegacyValuationDate.LegacyValuationDate] = Field(None, description="Details of the days on which calculations are to be made to determine the Delivery Amount and/or Return Amount.")
    """
    Details of the days on which calculations are to be made to determine the Delivery Amount and/or Return Amount.
    """
    legacyValuationTime: Optional[cdm.legaldocumentation.csa.LegacyValuationTime.LegacyValuationTime] = Field(None, description="The time by which the value of the collateral and obligations to transfer or return collateral are to be calculated relative to the Valuation Date.")
    """
    The time by which the value of the collateral and obligations to transfer or return collateral are to be calculated relative to the Valuation Date.
    """
    legacyValuationAgent: Optional[cdm.legaldocumentation.csa.LegacyValuationAgent.LegacyValuationAgent] = Field(None, description="Details of the party calculating the value of collateral to be delivered or returned.")
    """
    Details of the party calculating the value of collateral to be delivered or returned.
    """

import cdm 
import cdm.legaldocumentation.csa.CalculationAgentTerms
import cdm.legaldocumentation.csa.BespokeCalculationDate
import cdm.legaldocumentation.csa.BespokeCalculationTime
import cdm.legaldocumentation.csa.CalculationDateLocation
import cdm.legaldocumentation.csa.NotificationTime
import cdm.legaldocumentation.csa.CollateralValuationAgent
import cdm.legaldocumentation.csa.LegacyValuationDate
import cdm.legaldocumentation.csa.LegacyValuationTime
import cdm.legaldocumentation.csa.LegacyValuationAgent
