# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CalculationAgentTerms']


class CalculationAgentTerms(BaseDataClass):
    """
    A class to specify Calculation Agent for purposes of Initial or Variation Margin agreements.
    """
    party: List[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field([], description="The party which is specified as Calculation Agent for Initial Margin.")
    """
    The party which is specified as Calculation Agent for Initial Margin.
    """
    bespokeCalculationAgentTerms: Optional[str] = Field(None, description="The Calculation Agent (IM) terms when specified.")
    """
    The Calculation Agent (IM) terms when specified.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'party', 'bespokeCalculationAgentTerms', necessity=True)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
