# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AmendmentEffectiveDate']


class AmendmentEffectiveDate(BaseDataClass):
    """
    A class to specify the effective date of the Amendment to Termination Currency. This date can be specified as either an actual date, a specific date (e.g. the annex date) or as a custom provision.
    """
    date: Optional[datetime.date] = Field(None, description="The effective date of the Amendment to Termination Currency when specified as an actual date.")
    """
    The effective date of the Amendment to Termination Currency when specified as an actual date.
    """
    specificDate: Optional[cdm.legaldocumentation.csa.AmendmentEffectiveDateEnum.AmendmentEffectiveDateEnum] = Field(None, description="The effective date of the Amendment to Termination Currency when specified as relative to another date (e.g. the annex date).")
    """
    The effective date of the Amendment to Termination Currency when specified as relative to another date (e.g. the annex date).
    """
    customProvision: Optional[str] = Field(None, description="The effective date of the Amendment to Termination Currency when specified as a non normalized custom provision.")
    """
    The effective date of the Amendment to Termination Currency when specified as a non normalized custom provision.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'date', 'specificDate', 'customProvision', necessity=True)

import cdm 
import cdm.legaldocumentation.csa.AmendmentEffectiveDateEnum
