# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['AdditionalTypeEnum']

class AdditionalTypeEnum(Enum):
    """
    The enumerated values to specify the Additional Type of transaction that can require the collection or delivery of initial margin under a given regulatory regime for the purposes of Covered Transactions.
    """
    EQUITY_OPTION_OR_INDEX_OPTION = "EquityOptionOrIndexOption"
    """
    Single stock equity option or index option transaction as referred to in the transitional provisions (if any) of the EMIR RTS.
    """
    NOT_APPLICABLE = "NotApplicable"
    """
    No Additional Type of transaction is applicable to the regulatory regulatory regime.
    """
    OTHER = "Other"
