# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AdditionalType']


class AdditionalType(BaseDataClass):
    """
    The specification of the Additional Type of transaction that can require the collection or delivery of initial margin under a given regulatory regime for the purposes of Covered Transactions.
    """
    standardValue: cdm.legaldocumentation.csa.AdditionalTypeEnum.AdditionalTypeEnum = Field(..., description="The qualification of the Additional Type of transaction that can require the collection or delivery of initial margin when specified as a standard value.")
    """
    The qualification of the Additional Type of transaction that can require the collection or delivery of initial margin when specified as a standard value.
    """
    customValue: Optional[str] = Field(None, description="The qualification of the Additional Type of transaction that can require the collection or delivery of initial margin when specified as a custom value by the parties to the legal agreement.")
    """
    The qualification of the Additional Type of transaction that can require the collection or delivery of initial margin when specified as a custom value by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_CustomValue(self):
        """
        The specification of a custom value by the parties to the legal agreement takes place alongside the qualification of the `Other` value as part of the AdditionalTypeEnum.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "customValue"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "standardValue"), "=", rosetta_resolve_attr(AdditionalTypeEnum, "OTHER")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_StandardValue(self):
        """
        The specification of a standard value by the parties to the legal agreement is done through the qualification of a value distinct than `Other` as part of the AdditionalTypeEnum, and implies that the customerValue is not being qualified.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "customValue")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(any_elements(rosetta_resolve_attr(self, "standardValue"), "<>", rosetta_resolve_attr(AdditionalTypeEnum, "OTHER")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.AdditionalTypeEnum
from cdm.legaldocumentation.csa.AdditionalTypeEnum import AdditionalTypeEnum
