/*
 * Decompiled with CFR 0.152.
 */
package org.isda.cdm.qualify;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandler;
import com.rosetta.util.CollectionUtils;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class EconomicTermsQualificationHandler
implements QualificationHandler<EconomicTerms, NonTransferableProduct, NonTransferableProduct.NonTransferableProductBuilder> {
    public Class<EconomicTerms> getQualifiableClass() {
        return EconomicTerms.class;
    }

    public EconomicTerms getQualifiableObject(NonTransferableProduct product) {
        return Optional.ofNullable(product).map(NonTransferableProduct::getEconomicTerms).orElse(null);
    }

    public String getQualifier(NonTransferableProduct productBase) {
        return Optional.ofNullable(productBase).map(NonTransferableProduct::getTaxonomy).orElse(Collections.emptyList()).stream().map(ProductTaxonomy::getProductQualifier).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void setQualifier(NonTransferableProduct.NonTransferableProductBuilder productBuilder, String qualifier) {
        ProductTaxonomy.ProductTaxonomyBuilder productTaxonomyBuilder = CollectionUtils.emptyIfNull(productBuilder.getTaxonomy()).stream().filter(t -> t.getProductQualifier() != null).findFirst().orElse(null);
        if (productTaxonomyBuilder != null) {
            productTaxonomyBuilder.setProductQualifier(qualifier).setSource(TaxonomySourceEnum.ISDA);
        } else {
            productBuilder.addTaxonomy(ProductTaxonomy.builder().setProductQualifier(qualifier).setSource(TaxonomySourceEnum.ISDA));
        }
    }
}

