/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.VolatilityCapFloor;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="VolatilityCapFloorPositiveCaps")
@ImplementedBy(value=Default.class)
public interface VolatilityCapFloorPositiveCaps
extends Validator<VolatilityCapFloor> {
    public static final String NAME = "VolatilityCapFloorPositiveCaps";
    public static final String DEFINITION = "if totalVolatilityCap exists then totalVolatilityCap >= 0 and if volatilityCapFactor exists then volatilityCapFactor >= 0";

    public static class NoOp
    implements VolatilityCapFloorPositiveCaps {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityCapFloor volatilityCapFloor) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements VolatilityCapFloorPositiveCaps {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityCapFloor volatilityCapFloor) {
            ComparisonResult result = this.executeDataRule(volatilityCapFloor);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)VolatilityCapFloorPositiveCaps.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VolatilityCapFloor", (RosettaPath)path, (String)VolatilityCapFloorPositiveCaps.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)VolatilityCapFloorPositiveCaps.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VolatilityCapFloor", (RosettaPath)path, (String)VolatilityCapFloorPositiveCaps.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(VolatilityCapFloor volatilityCapFloor) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)volatilityCapFloor).map("getTotalVolatilityCap", _volatilityCapFloor -> _volatilityCapFloor.getTotalVolatilityCap())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult = ExpressionOperators.exists((Mapper)MapperS.of((Object)volatilityCapFloor).map("getVolatilityCapFactor", _volatilityCapFloor -> _volatilityCapFloor.getVolatilityCapFactor())).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)volatilityCapFloor).map("getVolatilityCapFactor", _volatilityCapFloor -> _volatilityCapFloor.getVolatilityCapFactor()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All) : ComparisonResult.successEmptyOperand((String)"");
                    return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)volatilityCapFloor).map("getTotalVolatilityCap", _volatilityCapFloor -> _volatilityCapFloor.getTotalVolatilityCap()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).and(ifThenElseResult);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

