/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceSchedulePositiveAssetPrice")
@ImplementedBy(value=Default.class)
public interface PriceSchedulePositiveAssetPrice
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceSchedulePositiveAssetPrice";
    public static final String DEFINITION = "if (priceType = PriceTypeEnum -> ExchangeRate or priceType = PriceTypeEnum -> AssetPrice) and arithmeticOperator is absent then value > 0";

    public static class NoOp
    implements PriceSchedulePositiveAssetPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceSchedulePositiveAssetPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceSchedulePositiveAssetPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveAssetPrice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceSchedulePositiveAssetPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveAssetPrice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.EXCHANGE_RATE)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.ASSET_PRICE)), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)priceSchedule).map("getArithmeticOperator", _priceSchedule -> _priceSchedule.getArithmeticOperator()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)priceSchedule).map("getValue", _priceSchedule -> _priceSchedule.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

